<?php
/**
 * @package		Joomla.Site
 * @subpackage	com_contact
 * @copyright	Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.framework');

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
?>
<?php if (empty($this->items)) : ?>
	<p> <?php echo JText::_('COM_CONTACT_NO_ARTICLES'); ?>	 </p>
<?php else : ?>

<form action="<?php echo htmlspecialchars(JFactory::getURI()->toString()); ?>" method="post" name="adminForm" id="adminForm">
<?php if ($this->params->get('show_pagination_limit')) : ?>
	<fieldset class="filters">
	<legend class="hidelabeltxt"><?php echo JText::_('JGLOBAL_FILTER_LABEL'); ?></legend>

		<div class="display-limit">
			<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>&#160;
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
	</fieldset>
<?php endif; ?>
	<ul class="category list-striped">
		<?php foreach ($this->items as $i => $item) : ?>
			<?php if ($this->items[$i]->published == 0) : ?>
				<li class="system-unpublished cat-list-row<?php echo $i % 2; ?>">
			<?php else: ?>
				<li class="cat-list-row<?php echo $i % 2; ?>" >
			<?php endif; ?>

				<p>
					<div class="list-title">
						<a href="<?php echo JRoute::_(ContactHelperRoute::getContactRoute($item->slug, $item->catid)); ?>">
							<span class="label-mobile label-mobile-info"><?php echo $item->name; ?></span>
						</a>
						<?php if ($this->items[$i]->published == 0) : ?>
							<span class="label label-warning"><?php echo JText::_('JUNPUBLISHED'); ?></span>
						<?php endif; ?>
					</div>
					<?php if ($this->params->get('show_position_headings')) : ?>
							<?php echo $item->con_position; ?><br/>
					<?php endif; ?>
					<?php if ($this->params->get('show_email_headings')) : ?>
							<?php echo $item->email_to; ?>
					<?php endif; ?>
					<?php if ($this->params->get('show_suburb_headings') AND !empty($item->suburb)) : ?>
						<?php echo $item->suburb . ', '; ?>
					<?php endif; ?>

					<?php if ($this->params->get('show_state_headings') AND !empty($item->state)) : ?>
						<?php echo $item->state . ', '; ?>
					<?php endif; ?>

					<?php if ($this->params->get('show_country_headings') AND !empty($item->country)) : ?>
						<?php echo $item->country; ?><br/>
					<?php endif; ?>
				</p>
				
				<span class="pull-right">
					<?php if ($this->params->get('show_telephone_headings') AND !empty($item->telephone)) : ?>
						<?php echo JText::_('COM_CONTACT_TELEPHONE') . ': ' .  $item->telephone; ?><br/>
					<?php endif; ?>

					<?php if ($this->params->get('show_mobile_headings') AND !empty ($item->mobile)) : ?>
							<?php echo JText::_('COM_CONTACT_MOBILE') . ': ' .  $item->mobile; ?><br/>
					<?php endif; ?>

					<?php if ($this->params->get('show_fax_headings') AND !empty($item->fax) ) : ?>
						<?php echo JText::_('COM_CONTACT_FAX') . ': ' .  $item->fax; ?><br/>
					<?php endif; ?>
				</span>
			</li>
		<?php endforeach; ?>
	</ul>
		
	<?php if ($this->params->get('show_pagination')) : ?>
	<div class="pagination">
		<?php if ($this->params->def('show_pagination_results', 1)) : ?>
		<p class="counter">
			<?php echo $this->pagination->getPagesCounter(); ?>
		</p>
		<?php endif; ?>
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php endif; ?>
	<div>
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	</div>
</form>
<?php endif; ?>
