<?php
/**
 * @author Joomla! Extensions Store
 * @package RESPONSIVIZER::ROUTER::plugins::system
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');
define('ROUTER_MODE_SKIP_SEF', 2);
define('ROUTER_MODE_SKIP_RAW', -1);
jimport('joomla.plugin.plugin');

/**
 * Observer class notified on events
 * 
 * @author Joomla! Extensions Store
 * @package RESPONSIVIZER::ROUTER::plugins::system
 * @since 2.0
 */
class plgSystemRouterReplacer extends JPlugin {
	/**
	 * Manage custom redirects for desktop->mobile links to menu
	 *
	 * @access private
	 * @return void
	 */
	private function customRedirectsRoute () {
		// DB connector
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		
		// Load all custom redirects
		$query = $db->getQuery(true);
		$query->select($db->nameQuote('itemid_source'));
		$query->select($db->nameQuote('itemid_target'));
		$query->from($db->nameQuote('#__rvzr_redirects'));
		$query->where($db->nameQuote('published') . '= 1');
		$activeRedirects = $db->setQuery($query)->loadObjectList();
		
		
		// Found some custom redirects active, now search for a match
		if(count($activeRedirects)) {
			$menu = $app->getMenu();
			$activeMenu = $menu->getActive();
			$currentItemid = $activeMenu->id;
			
			// Get the router
			$router = $app->getRouter();
			
			//Avoid risk of recursion on multiple parse on same request
			$clonedRouter = clone($router);
			
			foreach ($activeRedirects as $activeRedirect) {
				// Check for a match
				if($currentItemid != $activeRedirect->itemid_source) {
					continue;
				}
				
				// Get the menu item to switch to as the set home for mobile devices from settings
				$switchToItemid = $activeRedirect->itemid_target;
				if(!$switchToItemid) {
					continue;
				}
				$switchToMenu = $menu->getItem($switchToItemid);
				
				// Parse new JUri route
				$newUriInstance = JUri::getInstance(JUri::base() . $switchToMenu->route);
				$result = $clonedRouter->parse($newUriInstance);
				
				// Overwrite REQUEST vars in current application dispatch, notice: skipped entirely when language filter plugin is active and do redirect
				JRequest::set($result, 'get', true);
			}
		}
	}
	
	/**
	 * Manage after routing event
	 *
	 * @access public
	 * @return boolean
	 */
	public function onAfterRoute() {
		$app = JFactory::getApplication();
		$document = JFactory::getDocument();
		$template = $app->getTemplate();
		if ($document->getType() !== 'html' || JRequest::getCmd('tmpl') === 'component' || $template !== $this->params->get('template')) {
			return false;
		}

		if (JRequest::getVar("task") == "edit" || $app->isAdmin() || JRequest::getVar("option") == 'com_users' || JRequest::getVar("option") == 'com_search') {
			return false;
		}
		
		// Detect the home menu itemid in standard mode - keep multilanguage multimenu home id
		$menu = $app->getMenu();
		$activeMenu = $menu->getActive();
		if(!is_object($activeMenu)) {
			return false;
		}
		
		$currentItemid = $activeMenu->id;
		$isHome = (bool)$activeMenu->home;

		// If home route detected get the custom mobile and overwite router parse and set request vars
		if($isHome && $this->params->get('mobile_homepage_menuid') && $this->params->get('mobile_homepage')) {
			// Get the router
			$router = $app->getRouter();
			
			//Avoid risk of recursion on multiple parse on same request
			$clonedRouter = clone($router);
			
			// Get the menu item to switch to as the set home for mobile devices from settings
			$switchToItemid = $this->params->get('mobile_homepage_menuid');
			if(!$switchToItemid) {
				return false;
			}
			$switchToMenu = $menu->getItem($switchToItemid);
			
			// Parse new JURI route
			$newUriInstance = JURI::getInstance(JUri::base() . $switchToMenu->route);
			$result = $clonedRouter->parse($newUriInstance);
			
			// Overwrite REQUEST vars in current application dispatch
			JRequest::set($result, 'get', true);
		} else {
			// Check if some custom redirects are set and enabled
			if($this->params->get('redirects_enable', 0)) {
				$this->customRedirectsRoute();
			}
		}
	}

	public function __construct(&$subject) {
		parent::__construct($subject);
		$this->params = JComponentHelper::getParams('com_responsivizer');
	}
}
