<?php
/**
 * @author Joomla! Extensions Store
 * @package RESPONSIVIZER::PLUGINSWITCHER::plugins::system
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.plugin.plugin');

/**
 * Observer class notified on events
 * 
 * @author Joomla! Extensions Store
 * @package RESPONSIVIZER::PLUGINSWITCHER::plugins::system
 * @since 1.0
 */
class plgSystemResponsivizer extends JPlugin {
	/**
	 * Detect mobile requests
	 * 
	 * @access private
	 * @return boolean
	 */
	private function isMobileRequest() {
		$app = JFactory::getApplication();
		$isMobile = false;

		require_once(JPATH_PLUGINS . '/' . "system" . '/' . "responsivizer" . '/' . "responsivizer" . '/' . "device.php");
		$ua = new responsivizer_uagent_info($this->params->get('enable_debug', 0));

		$isMobile = ($ua->DetectSmartphone() || $ua->DetectTierTablet());

		if ((int) $this->params->get('include_tablets', 0) == 0) {
			if ($ua->DetectTierTablet()) {
				$isMobile = false;
			}
		}
		
		$app->set('ismobile', $isMobile);
		
		return $isMobile;
	}
	
	/**
	 * Detect if client is a valid mobile, AKA is:
	 * -application ismobile true on first request from this device
	 * -cookie for responsivizer template has been set after first request and detect
	 *
	 * @access private
	 * @return int
	 */
	private function isValidMobile() {
		// Check if mobile device is set on application exec
		$app = JFactory::getApplication();
	
		$isMobileOnApp = $app->get('ismobile', false);
		
		// Check if mobile device is set as template cookie after first requests
		$isMobileOnCookie = isset($_COOKIE[JApplication::getHash ( 'RESPONSIVIZER_TEMPLATE' . $_SERVER['HTTP_USER_AGENT'] )]);
	
		return $isMobileOnApp || $isMobileOnCookie;
	}
	
	/**
	 * Switch template to new target responsive one
	 *
	 * @access private
	 * @return void
	 */
	protected function _setTemplate($tpl = null) {
		if (empty($tpl)) {
			return;
		} else {
			$app = JFactory::getApplication();
			$app->setTemplate($tpl);
		}
	}
	
	/**
	 * onAfterInitialise handler
	 *
	 * @access	public
	 * @return boolean
	 */
	public function onAfterInitialise() {
		$app = JFactory::getApplication();
	
		// Execute only in frontend and if a valid mobile request is detected
		if($app->isAdmin()) {
			return false;
		}

		// Valid mobile already detected?
		$isMobileRequest = null;
		$isAlreadyMobile = $this->isValidMobile();
		if(!$isAlreadyMobile) {
			// Check if it's a new mobile request
			$isMobileRequest = $this->isMobileRequest();
		}

		// Check if plugins exclusions are enabled and a mobile request or already detection is active
		if($this->params->get('enable_plugins_exclusions', 0) && ($isMobileRequest || $isAlreadyMobile)) {
			// Load plugins to exclude
			$excludedPlugins = $this->params->get('plugins_excluded', 0);
				
			if(count($excludedPlugins) && !in_array('0', $excludedPlugins)) {
				// Ensure preloading of needed plugins groups to be excluded
				JPluginHelper::importPlugin('content');
				JPluginHelper::importPlugin('system');
	
				// Instance of the subject JDispatcher
				$dispatcher = JDispatcher::getInstance();
	
				foreach ($excludedPlugins as $excludedPlugin) {
					list($pluginType, $pluginName) = explode('-', $excludedPlugin);
					// Build plugins structure
					$pluginToExclude = array('type'=>$pluginType, 'name'=>$pluginName);
						
					$pluginClassName = 'Plg' . ucfirst($pluginToExclude['type']) . ucfirst($pluginToExclude['name']);
					// Manage plugins exclusions at a early stage in the Joomla CMS app execution lifecycle
						
					if(class_exists($pluginClassName)) {
						// Get plugin observer object based on type/name
						$plugin = JPluginHelper::getPlugin($pluginToExclude['type'], $pluginToExclude['name']);
						// Instantiate the observer object and inject the subject for the attach
						$pluginInstanceToExclude = new $pluginClassName($dispatcher, (array) $plugin);
						// Now search and detach it
						$dispatcher->detach($pluginInstanceToExclude);
					}
				}
			}
		}
	}
	
	/**
	 * Main dispatch method
	 *
	 * @access private
	 * @return boolean
	 */
	public function onAfterRoute() {
		$app = JFactory::getApplication();
		$changeTplRequest = null;
		$doChangeReq = false;
		$tpl = null;
		$cookieLifetime = 365 * 24 * 60 * 60;
		$desktopFallbackCookieLifetime = $this->params->get('desktop_fallback_cookie_lifetime', 10);
		$defaultMobileTemplate = $this->params->get('template', 'responsivizer');
		// No remember me for admin
		if ($app->isAdmin() || JRequest::getCmd('noswitch', false)) {
			return;
		}

		// Do nothing if this plugin not enable the switcher function
		$enabledSwitcher = $this->params->get('switch_enabled', 0);
		if (!$enabledSwitcher) {
			return;
		}

		//Switch always if params activated or header is forced from HTTPClient to generate manifest
		$switcherHTTPHeader = JRequest::getVar('HTTP_X_REQUESTED_WITH', false, 'SERVER');
		$alwaysSwitcher = $this->params->get('switch_always', 0);
		if ($alwaysSwitcher || $switcherHTTPHeader === 'manifest') {
			$changeTplRequest = $defaultMobileTemplate;
		}

		// No change template detected by forcing switch always or HTTP header for backend copy
		if (!$changeTplRequest) {
			$changeTplRequest = JRequest::getString('responsivizer_template', null); // Try to get a desktop version forcing by REQUEST
			if ($changeTplRequest) {
				$doChangeReq = true;
				if ($changeTplRequest == 'desktop') {
					$cookieLifetime = $desktopFallbackCookieLifetime;
				}
			} else {
				jimport('joomla.utilities.utility');
				$hash = JApplication::getHash('RESPONSIVIZER_TEMPLATE' . $_SERVER['HTTP_USER_AGENT']);
				$changeTplRequest = JRequest::getString($hash, '', 'cookie'); // Try to get a switcher template from COOKIE by precedent detection for this device
				if ($changeTplRequest) {
					$doChangeReq = true;
				}
				if ($changeTplRequest == 'desktop') {
					$cookieLifetime = $desktopFallbackCookieLifetime;
				}
			}
		} else {
			$doChangeReq = true;
		}

		// Request to change template detected
		if ($doChangeReq) {
			// Apply this change tpl request
			$tpl = $changeTplRequest;
		} else {
			// Detect only on first time request mobile device user, later used by cookie value
			if ($enabledSwitcher) {
				$isMobile = $app->get('ismobile', false);
				if ($isMobile) {
					$tpl = $defaultMobileTemplate;
				}
			}
		}

		// Set now new detected template to switch to for mobile if any
		$this->_setTemplate($tpl);
		
		// Save to cookie for subsequent requests
		if(!$alwaysSwitcher) {
			$config = JFactory::getConfig();
			$cookie_domain = $config->get('cookie_domain', '');
			$cookie_path = $config->get('cookie_path', '/');
			$lifetime = time() + $cookieLifetime;
			jimport('joomla.utilities.utility');
			setcookie(JApplication::getHash('RESPONSIVIZER_TEMPLATE' . $_SERVER['HTTP_USER_AGENT']), $tpl, $lifetime, $cookie_path, $cookie_domain); // PUSH in COOKIE
		}

		// Force tp=1 when Responsivizer is installed
		JComponentHelper::getParams('com_templates')->set('template_positions_display', true);
	}
	
	/**
	 * Class constructor, manage params from component
	 *
	 * @access private
	 * @return boolean
	 */
	public function __construct(&$subject) {
		parent::__construct($subject);
		$this->params = JComponentHelper::getParams('com_responsivizer');
	}
}

/**
 * Patch for Advanced Modules Manager
 * Requires that Responsivizer template switcher plugin is loaded before AMM
 * It's limited to avoid execution of AMM for mobile requests
 *
 * @access public
 */
function responsivizerPatchForAdvancedModulesManager() {
	jimport('joomla.filesystem.file');
	$cparams = JComponentHelper::getParams('com_responsivizer');
	
	// Include the moduleHelper
	if (JFile::exists(JPATH_PLUGINS . '/system/nnframework/nnframework.php') || $cparams->get('force_modulehelper_override', 0)) {
		$app = JFactory::getApplication();
		
		// No remember me for admin
		if ($app->isAdmin() || JRequest::getCmd('noswitch', false)) {
			return;
		}

		// Do nothing if this plugin not enable the switcher function
		$enabledSwitcher = $cparams->get('switch_enabled', 0);
		if (!$enabledSwitcher) {
			return;
		}

		// Avoid fatal error if AMM plugin is published BEFORE Responsivizer template switcher
		$classes = get_declared_classes();
		if (!in_array('JModuleHelper', $classes) && !in_array('jmodulehelper', $classes)) {
			$isMobile = false;
			//Switch always if params activated or header is forced from HTTPClient to generate manifest
			$switcherHTTPHeader = JRequest::getVar('HTTP_X_REQUESTED_WITH', false, 'SERVER');
			$alwaysSwitcher = $cparams->get('switch_always', 0);
			$explicitTemplate = JRequest::getvar('template', null);
			if ($alwaysSwitcher || $switcherHTTPHeader === 'manifest' || $explicitTemplate === 'responsivizer') {
				$isMobile = true;
			} else {
				$hash = JApplication::getHash('RESPONSIVIZER_TEMPLATE' . $_SERVER['HTTP_USER_AGENT']);
				$isMobile = JRequest::getString($hash, '', 'cookie'); // Try to get a switcher template from COOKIE by precedent detection for this device
			}

			if(!$isMobile) {
				require_once(JPATH_PLUGINS . '/' . "system" . '/' . "responsivizer" . '/' . "responsivizer" . '/' . "device.php");
				$ua = new responsivizer_uagent_info();
				$isMobile = ($ua->DetectSmartphone() || $ua->DetectTierTablet());
				
				if ((int) $cparams->get('include_tablets', 0) == 0) {
					if ($ua->DetectTierTablet()) {
						$isMobile = false;
					}
				}
			}
			
			$changeTplRequest = JRequest::getString('responsivizer_template', null); // Try to get a desktop version forcing by REQUEST
			$hash = JApplication::getHash('RESPONSIVIZER_TEMPLATE' . $_SERVER['HTTP_USER_AGENT']);
			$cookieTplRequest = JRequest::getString($hash, '', 'cookie');
			if ($changeTplRequest == 'desktop' || $cookieTplRequest == 'desktop') {
				$isMobile = false;
			}

			// Preload here the modules helper class, bypass Joomla autoloader and everything else after this, also AMM
			if($isMobile) {
				require_once JPATH_ROOT . '/templates/responsivizer/framework/modules/helper.php';
			}
		}
	}
}

// Execute always patch asap in Joomla execution
responsivizerPatchForAdvancedModulesManager();