<?php
/** 
 * App runner
 * @package RESPONSIVIZER::plugins::system
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

class ResponsivizerToolbar extends JToolBar {
	/**
	 * Stores the singleton instances of various toolbar.
	 *
	 * @var JToolbar
	 * @since 11.3
	 */
	protected static $instances = array();
	
	/**
	 * Fake JToolbar global object with accessor to bar protected property
	 *
	 * @param string  $name  The name of the toolbar.
	 * @return ResponsivizerToolbar object.
	 *
	 * @since   11.1
	 */
	public static function getInstance($name = 'toolbar') {
		if (empty(self::$instances[$name])) {
			self::$instances[$name] = new ResponsivizerToolbar($name);
		}

		return self::$instances[$name];
	}

	/**
	 * Render a null tool bar.
	 *
	 * @return  null
	 *
	 */
	public function render() {
		return null;
	}

	/**
	 * Public accessor method to clear toolbar
	 * @access public
	 * @return void
	 */
	public function clearItems() {
		$this->_bar = array();
	}
}