<?php
/** 
 * App runner
 * @package RESPONSIVIZER::plugins::system
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
// no direct access
defined('_JEXEC') or die('Restricted access');
jimport('joomla.plugin.plugin');
jimport('joomla.html.toolbar');

class plgSystemNoToolbar extends JPlugin {
	/**
	 * Check if we are correct to execute plugin
	 * 
	 * @access private
	 * @return boolean
	 */
	private function checkIfCorrectExecution($session) {
		// Patch for rt_missioncontrol
		if(file_exists(JPATH_ADMINISTRATOR . '/templates/rt_missioncontrol')) {
			return false;
		}
		
		include_once JPATH_ROOT . '/plugins/system/notoolbar/toolbarclass.php';
		
		$app = JFactory::getApplication();
		$clientID = $app->getClientId();
		$option = JRequest::getCmd('option', null);
		$rvzrIFrame = JRequest::getCmd('rvzr', null);
		$noSwitch = JRequest::getvar('noswitch', false);
		$tp = JRequest::getvar('tp', false);
		
		// Force tp=1 during comparison between copy module source target
		if($clientID == 0 && $tp == 1 && $noSwitch == 1) {
			JComponentHelper::getParams('com_templates')->set('template_positions_display', true);
		}
		
		if(($clientID == 1 && $rvzrIFrame == 1 && $option == 'com_templates') || ($clientID == 1 && $session->get('rvzr', false) && $option == 'com_templates')) {
			return true;
		}
		return false;
	}
	
	/**
	 * onAfterInitialise handler
	 *
	 * @access	public
	 * @return null
	 */
	public function onAfterInitialise() {
		// Session management
		$session = JFactory::getSession();
		
		// Danger!!! Exec only when needed
		if($this->checkIfCorrectExecution($session)) {
			$toolbarinstance = ResponsivizerToolbar::getInstance();
		}
	}

	/**
	 * onAfterInitialise handler
	 *
	 * @access	public
	 * @return null
	 */
	public function onAfterDispatch() {
		// Session management
		$session = JFactory::getSession();
		
		// Danger!!! Exec only when needed
		if($this->checkIfCorrectExecution($session)) {
			// Reset current toolbar
			$toolbarinstance = ResponsivizerToolbar::getInstance();
			$toolbarinstance->clearItems();
			
			// Reset title
			$app = JFactory::getApplication();
			$app->JComponentTitle = null;
			
			// Document manipulation and script helper execution
			$doc = JFactory::getDocument();
			$doc->addStyleDeclaration('div#toolbar-box{display:none;}
									   div.CodeMirror-wrapping{height:100% !important}
									   div.editor-border iframe{min-height:500px !important}
									   div.fltrt:nth-child(3) #template-manager-css{display:none}');
			
			$option = JRequest::getCmd('option', null);
			$view = JRequest::getCmd('view', null);
			// If we are in edit mode we call parent window JS function to add save button
			if($option == 'com_templates' && $view == 'source') {
				$doc->addScriptDeclaration('if(window.parent.ResponsivizerEditorTemplate === Object(window.parent.ResponsivizerEditorTemplate)){window.parent.ResponsivizerEditorTemplate.injectToolbarButtons();}');
			}
			
			// Finally ensure to render only component output
			JRequest::setVar('tmpl', 'component');
			
			// Place rvzr var in session for later requests not stateless
			$session->set('rvzr', 1);
		} else {
			// Clear session var as soon as exits from com_templates for normal toolbar behavior
			if($session->has('rvzr')) {
				$session->clear('rvzr');
			}
		}
	}
}
