<?php 
/**
 * @author Joomla! Extensions Store
 * @package RESPONSIVIZER::MODULESLIDESHOW::modules::mod_responsivizerslideshow
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();
$target = $cParams->get ( 'target' );

/**
 * Helper class pseudo MVC
 * @author Joomla! Extensions Store
 * @package RESPONSIVIZER::MODULESLIDESHOW::modules::mod_responsivizerslideshow
 * @since 1.0
 */
class modResponsivizerHelper {
	// Get images from the component configuration, default slideshow with support for title, caps and links
	public static function getImages(&$cParams) {
		$imgsAndCaps = array ();
		
		$i = 1;
		
		while ( $cParams->get ( 'image_' . $i )) : 
			// if image_ + caption + link
			if (($cParams->get ( 'image_' . $i )) && ($cParams->get ( 'imagecaption_' . $i )) && ($cParams->get ( 'imagelink_' . $i ) != '')) { 
				$listitem = "<li><a target='" . $cParams->get ( 'target' ) . "' href='" . $cParams->get ( 'imagelink_' . $i ) . "'><img class='slide' title='' alt='" . $cParams->get ( 'imagealt_' . $i ) . "' src='" . JURI::root () .  $cParams->get ( 'image_' . $i ) . "' /><p class='responsivizer-caption' style='color:" . $cParams->get ( 'color_caption' ) . "'>" . $cParams->get ( 'imagecaption_' . $i ) . "</p></a></li>";
				array_push ( $imgsAndCaps, $listitem );
		 		// if image_ + no caption + link
			} else if (($cParams->get ( 'image_' . $i )) && ($cParams->get ( 'imagecaption_' . $i ) == null) && ($cParams->get ( 'imagelink_' . $i ) != '')) {
			 	$listitem = "<li><a target='" . $cParams->get ( 'target' ) . "' href='" . $cParams->get ( 'imagelink_' . $i ) . "'><img class='slide' title='' alt='" . $cParams->get ( 'imagealt_' . $i ) . "' src='" . JURI::root () .  $cParams->get ( 'image_' . $i ) . "' /></a></li>";
				array_push ( $imgsAndCaps, $listitem );
			 		// if image_ + caption + no link
			} else if (($cParams->get ( 'image_' . $i )) && ($cParams->get ( 'imagecaption_' . $i )) && ($cParams->get ( 'imagelink_' . $i ) == '')) {
			 	$listitem = "<li><img class='slide' title='' alt='" . $cParams->get ( 'imagealt_' . $i ) . "' src='" . JURI::root () . $cParams->get ( 'image_' . $i ) . "' /><p class='responsivizer-caption' style='color:" . $cParams->get ( 'color_caption' ) . "'>" . $cParams->get ( 'imagecaption_' . $i ) . "</p></li>";
				array_push ( $imgsAndCaps, $listitem );
		 		// if image + no caption + no link
			} else if (($cParams->get ( 'image_' . $i )) && ($cParams->get ( 'imagecaption_' . $i ) == null) && ($cParams->get ( 'imagelink_' . $i ) == '')) {
		 		$listitem = "<li><img class='slide' title='' alt='" . $cParams->get ( 'imagealt_' . $i ) . "' src='" . JURI::root () . $cParams->get ( 'image_' . $i ) . "' /></li>";
				array_push ( $imgsAndCaps, $listitem );
			} 
			$i ++;
		endwhile;
		
		return $imgsAndCaps;
	}
	
	// Get images from a plain folder based on the module params for each instance, no support for title, caps, links
	public static function getFolderImages($params) {
		$folderImgs = array();
		
		$imagesFolder = $params->get('pathfolder', null);
		if($imagesFolder) {
			jimport('joomla.filesystem.folder');
			$folderImgs = JFolder::files(JPATH_SITE . '/images/' . $imagesFolder);
		}
		
		return $folderImgs;
	}
	
	public static function load_jquery(&$cParams) {
		$doc = JFactory::getDocument ();
		$app = JFactory::getApplication ();
		
		if(version_compare(JVERSION, '3.0', '>=')) {
			JHtml::_('jquery.framework');
		} else {
			if (!$app->get('jQuery') && !$app->get('jquery') && $cParams->get('tpl_load_jquery', 1)) {
				$doc->addScript ( JURI::root ( true ) . '/modules/mod_responsivizerslideshow/assets/js/jquery.js' );
				$app->set('jQuery', 1);
			}
		}
			
		$doc->addScript ( JURI::root ( true ) . '/modules/mod_responsivizerslideshow/assets/js/jquery.easing.js' );
	}
}