<?php
// namespace administrator\components\com_responsivizer\models;
/**
 * @package RESPONSIVIZER::REDIRECTS::administrator::components::com_responsivizer
 * @subpackage models
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

/**
 * Sources model concrete implementation <<testable_behavior>>
 *
 * @package RESPONSIVIZER::REDIRECTS::administrator::components::com_responsivizer
 * @subpackage models
 * @since 2.2
 */
class ResponsivizerModelRedirects extends ResponsivizerModel {
	/**
	 * Build list entities query
	 *
	 * @access protected
	 * @return string
	 */
	protected function buildListQuery() {
		// WHERE
		$where = array ('m.client_id = 0', 'm.type=' . $this->_db->quote('component'));
		$whereString = null;
		$orderString = null;
		// STATE FILTER
		if ($filter_state = $this->state->get ( 'state' )) {
			if ($filter_state == 'P') {
				$where [] = 's.published = 1';
			} else if ($filter_state == 'U') {
				$where [] = 's.published = 0';
			}
		}
	
		// TEXT FILTER
		if ($this->state->get ( 'searchword' )) {
			$where [] = "(m.title LIKE '%" . $this->state->get ( 'searchword' ) . "%'" . 
						"\n OR t.title LIKE '%" . $this->state->get ( 'searchword' ) . "%')";
		}
	
		if (count ( $where )) {
			$whereString = "\n WHERE " . implode ( "\n AND ", $where );
		}
	
		// ORDERBY
		if ($this->state->get ( 'order' )) {
			$orderString = "\n ORDER BY " . $this->state->get ( 'order' ) . " ";
		}
	
		// ORDERDIR
		if ($this->state->get ( 'order_dir' )) {
			$orderString .= $this->state->get ( 'order_dir' );
		}
	
		$query = "SELECT s.*," .
				 "\n m.title AS " . $this->_db->nameQuote('sourcetitle') . "," .
				 "\n t.title AS " . $this->_db->nameQuote('targettitle') .
				 "\n FROM #__rvzr_redirects AS s" .
				 "\n LEFT JOIN #__menu AS m ON m.id = s.itemid_source" .
				 "\n LEFT JOIN #__menu AS t ON t.id = s.itemid_target" .
				 $whereString .
				 $orderString;
	
		return $query;
	}
	
	/**
	 * Return select lists used as filter for listEntities
	 *
	 * @access public 
	 * @return array
	 */
	public function getFilters() {
		$filters ['state'] = JHtml::_ ( 'grid.state', $this->getState ( 'state' ) );
		
		return $filters;
	}
	
	/**
	 * Return select lists used as filter for editEntity
	 *
	 * @access public
	 * @param Object $record
	 * @return array
	 */
	public function getLists($record) {
		$lists = array ();
		// Grid states
		$lists ['published'] = JHtml::_ ( 'select.booleanlist', 'published', $record->itemid_source, $record->published );
		
		// Use Framework Elements
		$menuAvailableOptionsSource = ResponsivizerElementsMenuselect::getOptions($record->itemid_source, false, true);
		$menuAvailableOptionsTarget = ResponsivizerElementsMenuselect::getOptions(null, false, false);
		$lists['itemid_source'] = JHtml::_('select.genericlist', $menuAvailableOptionsSource, 'itemid_source', 'class="inputbox" data-validation="required" size="15"', 'value', 'text', $record->itemid_source, 'itemid_source' );
		$lists['itemid_target'] = JHtml::_('select.genericlist', $menuAvailableOptionsTarget, 'itemid_target', 'class="inputbox" data-validation="required" size="15"', 'value', 'text', $record->itemid_target, 'itemid_target' );
		
		return $lists;
	}
}