<?php
//namespace components\com_responsivizer\models\fields;
/** 
 * Form field list
 * @package RESPONSIVIZER::CONFIG::administrator::components::com_responsivizer 
 * @subpackage models
 * @subpackage fields
 * @author Joomla! Extensions Store 
 * @copyright (C)2014 Joomla! Extensions Store
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 */
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.form.fields.list');

/**
 * Renders a list of plugins entries for the type 'content' and 'system', grouped by type with multiple select options 
 *
 * @package RESPONSIVIZER::administrator::components::com_responsivizer 
 * @subpackage models
 * @subpackage fields
 * @since 2.2
 */
class JFormFieldPluginSelect extends JFormFieldList {
	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 * @since  11.1
	 */
	protected $type = 'PluginSelect';
	
	/**
	 * Method to get the field input markup for a generic list.
	 * Use the multiple attribute to enable multiselect.
	 *
	 * @return string The field input markup.
	 *
	 * @since 11.1
	 */
	protected function getInput() {
		// Initialize variables.
		$html = array ();
		$attr = '';
	
		$attr .= 'style="height: 200px;"';
		$attr .= $this->multiple ? ' multiple="multiple"' : '';
	
		// Get the field options.
		$options = ( array ) $this->getOptions ();
	
		$html = JHtml::_ ( 'select.genericlist', $options, $this->name, trim ( $attr ), 'value', 'text', $this->value, $this->id );
	
		return $html;
	}
	
	/**
	 * Build the multiple select list for Menu Links/Pages
	 * 
	 * @access public
	 * @return array
	 */
	protected function getOptions() {
		$pluginItemsSystem = JPluginHelper::getPlugin('system');
		$pluginItemsContent = JPluginHelper::getPlugin('content');
		$lastPluginType = null;
		$tmpPluginType = null;
		
		$allPluginEntries = array_merge($pluginItemsSystem, $pluginItemsContent);
		
		foreach ( $allPluginEntries as $plugin ) {
			if ($plugin->type != $lastPluginType) {
				if ($tmpPluginType) {
					$pluginItems [] = JHtml::_ ( 'select.option', '</OPTGROUP>' );
				}
				$pluginItems [] = JHtml::_ ( 'select.option', '<OPTGROUP>', $plugin->type );
				$lastPluginType = $plugin->type;
				$tmpPluginType = $plugin->type;
			}
			
			$pluginItems [] = JHtml::_ ( 'select.option', ($plugin->type . '-' . $plugin->name), $plugin->name );
		}
		if ($lastPluginType !== null) {
			$pluginItems [] = JHtml::_ ( 'select.option', '</OPTGROUP>' );
		}
		
		$noActiveOption = JHtml::_('select.option', '0', JText::_('COM_RESPONSIVIZER_NOPLUGIN_SELECTED'));
		array_unshift($pluginItems, $noActiveOption);
		
		return $pluginItems;
	}
}