<?php
// namespace administrator\components\com_responsivizer\controllers;
/**
 * @package RESPONSIVIZER::REDIRECTS::administrator::components::com_responsivizer
 * @subpackage controllers
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

/**
 * Main controller manager
 * @package RESPONSIVIZER::REDIRECTS::administrator::components::com_responsivizer
 * @subpackage controllers
 * @since 2.2
 */
class ResponsivizerControllerRedirects extends ResponsivizerController {
	/**
	 * Default listEntities
	 * 
	 * @access public
	 * @param $cachable string
	 *       	 the view output will be cached
	 * @return void
	 */
	function display($cachable = false, $urlparams = false) {
		// Set model state
		$option= $this->option; 

		$defaultModel = $this->setModelState('redirects');
		$filter_state = $this->getUserStateFromRequest ( "$option.redirects.filterstate", 'filter_state', null );
		$filter_order = $this->getUserStateFromRequest ( "$option.redirects.filter_order", 'filter_order', 'id', 'cmd' );
		
		// Set model state
		$defaultModel->setState('state', $filter_state); 
		$defaultModel->setState('order', $filter_order);  
		
		// Parent construction and view display
		parent::display($cachable);
	}
	  
	/**
	 * Class Constructor
	 * 
	 * @access public
	 * @return Object&
	 */
	public function __construct($config = array()) {
		parent::__construct ( $config );
		// Register Extra tasks
		$this->registerTask ( 'applyEntity', 'saveEntity' );
		$this->registerTask ( 'unpublish', 'publishEntities' );
		$this->registerTask ( 'publish', 'publishEntities' );
	}
}